#ifndef LG_SOUND_H
#define LG_SOUND_H

//THANKS TO BELOGIC

////////////////sound channels/////////////
#define SOUNDINIT			0x8000	// makes the sound restart
#define SOUNDDUTY87			0x0000	//87.5% wave duty
#define SOUNDDUTY75			0x0040	//75% wave duty
#define SOUNDDUTY50			0x0080	//50% wave duty
#define SOUNDDUTY25			0x00C0	//25% wave duty

#define SOUND1PLAYONCE		0x4000	// play sound once
#define SOUND1PLAYLOOP		0x0000	// play sound looped
#define SOUND1INIT			0x8000	// makes the sound restart
#define SOUND1SWEEPSHIFTS(n)	n	// number of sweep shifts (0-7)
#define SOUND1SWEEPINC		0x0000	// sweep add (freq increase)
#define SOUND1SWEEPDEC		0x0008	// sweep dec (freq decrese)
#define SOUND1SWEEPTIME(n)	(n<<4)	// time of sweep (0-7)
#define SOUND1ENVSTEPS(n)	(n<<8)	// envelope steps (0-7)
#define SOUND1ENVINC		0x0800	// envellope increase
#define SOUND1ENVDEC		0x0000	// envellope decrease
#define SOUND1ENVINIT(n)	(n<<12) // initial envelope volume (0-15)


#define SOUND2PLAYONCE		0x4000	// play sound once
#define SOUND2PLAYLOOP		0x0000	// play sound looped
#define SOUND2INIT			0x8000	// makes the sound restart
#define SOUND2ENVSTEPS(n)	(n<<8)	// envelope steps (0-7)
#define SOUND2ENVINC		0x0800	// envellope increase
#define SOUND2ENVDEC		0x0000	// envellope decrease
#define SOUND2ENVINIT(n)	(n<<12) // initial envelope volume (0-15)



#define SOUND3BANK32		0x0000	// Use two banks of 32 steps each
#define SOUND3BANK64		0x0020	// Use one bank of 64 steps
#define SOUND3SETBANK0		0x0000	// Bank to play 0 or 1 (non set bank is written to)
#define SOUND3SETBANK1		0x0040
#define SOUND3PLAY			0x0080	// Output sound

#define SOUND3OUTPUT0		0x0000	// Mute output
#define SOUND3OUTPUT1		0x2000	// Output unmodified
#define SOUND3OUTPUT12		0x4000	// Output 1/2
#define SOUND3OUTPUT14		0x6000	// Output 1/4
#define SOUND3OUTPUT34		0x8000  // Output 3/4

#define SOUND3PLAYONCE		0x4000	// Play sound once
#define SOUND3PLAYLOOP		0x0000	// Play sound looped
#define SOUND3INIT			0x8000	// Makes the sound restart


#define SOUND4PLAYONCE		0x4000	// play sound once
#define SOUND4PLAYLOOP		0x0000	// play sound looped
#define SOUND4INIT			0x8000	// makes the sound restart
#define SOUND4ENVSTEPS(n)	(n<<8)	// envelope steps (0-7)
#define SOUND4ENVINC		0x0800	// envellope increase
#define SOUND4ENVDEC		0x0000	// envellope decrease
#define SOUND4ENVINIT(n)	(n<<12) // initial envelope volume (0-15)


#define SOUND4STEPS7		0x0004
#define SOUND4STEPS15		0x0000
#define SOUND4PLAYONCE		0x4000
#define SOUND4PLAYLOOP		0x0000
#define SOUND4INIT			0x8000


//FOR CHANNEL 3
#define REG_WAVE_RAM0  *(volatile u32*)0x4000090		//???
#define REG_WAVE_RAM1  *(volatile u32*)0x4000094		//???
#define REG_WAVE_RAM2  *(volatile u32*)0x4000098		//???
#define REG_WAVE_RAM3  *(volatile u32*)0x400009C		//???





#define SOUND_OUTPUT_1_4				0
#define SOUND_OUTPUT_1_2				BIT00
#define SOUND_OUTPUT_FULL				BIT01
#define DSOUND_A_OUTPUT_HALF			0
#define DSOUND_A_OUTPUT_FULL			BIT02
#define DSOUND_B_OUTPUT_HALF			0
#define DSOUND_B_OUTPUT_FULL			BIT03
#define DSOUND_A_RIGHT_CHANNEL			BIT08
#define DSOUND_A_LEFT_CHANNEL			BIT09
#define DSOUND_A_TIMER_0				0
#define DSOUND_A_TIMER_1				BIT10
#define DSOUND_A_FIFO_RESET				BIT11
#define DSOUND_B_RIGHT_CHANNEL			BIT12
#define DSOUND_B_LEFT_CHANNEL			BIT13
#define DSOUND_B_TIMER_0				0
#define DSOUND_B_TIMER_1				BIT14
#define DSOUND_B_FIFO_RESET				BIT15

#endif


